﻿#if UNITY_ANDROID || UNITY_EDITOR 
using UnityEngine;
using System.Collections;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.Collections.Generic;

namespace quicksdk
{
	// QuickSDKListener
	public abstract class QuickSDKListener : MonoBehaviour
	{
		//callback
		public abstract void onInitSuccess();

		public abstract void onInitFailed(ErrorMsg message);

		public abstract void onLoginSuccess(UserInfo userInfo);

		public abstract void onLoginFailed(ErrorMsg errMsg);

		public abstract void onLogoutSuccess();

		public abstract void onPaySuccess(PayResult payResult);

		public abstract void onPayFailed(PayResult payResult);

		public abstract void onPayCancel(PayResult payResult);

		public abstract void onSubsSkuCallback(string skuId, string qkOrderId);

		public virtual void onShareSuccess()
		{
			Debug.Log("onShareSuccess default");
		}

		public virtual void onShareCancel()
		{
			Debug.Log("onShareCancel default");
		}

		public virtual void onShareFailed(string msg)
		{
			Debug.Log("onShareFailed default");
		}

		public virtual void onQueryGoogleSkuResult(List<GoogleSku> skus)
		{
			Debug.Log("onQueryGoogleSkuResult default");
		}

		public virtual void onBindUnbindUserFailed(BindUserInfo bindUserInfo)
		{
			Debug.Log("onBindUnbindUserFailed");
		}
		public virtual void onBindUnbindUserSuccess(BindUserInfo bindUserInfo)
		{
			Debug.Log("onBindUnbindUserSuccess");
		}

		public virtual void onLoginTraceEvent(string name, string msg)
		{
			Debug.Log("onLoginTraceEvent " + name);
		}

		public virtual void onCustomServiceMsgBack(string msgContent)
		{
			Debug.Log("onCustomServiceMsgBack " + msgContent);
		}

		public virtual void oNOpenReviewFinish()
		{
		}

		public virtual void onCheckPreRegisterSuccess()
		{
            Debug.Log("onCheckPreRegisterSuccess");
        }

		public virtual void onCustomerServiceClicked()
		{
			Debug.Log("onCustomerServiceClicked");
        }

		public virtual void onRegisterCallback(string uid,string userName){

		}

        public virtual void onConversionDataSuccess(Dictionary<string, string> dataMap)
        {
            Debug.Log("onConversionDataSuccess");
        }

        public virtual void onConversionDataFail(string s)
        {
            Debug.Log("onConversionDataFail " + s);
        }

        public virtual void onAppOpenAttribution(Dictionary<string, string> dataMap)
        {
            Debug.Log("onAppOpenAttribution ");
        }

        public virtual void onAttributionFailure(string s)
        {
            Debug.Log("onAttributionFailure " + s);
        }
        public virtual void onGetFirebaseAppInstanceId(string appInstanceId)
        {
        }
        public virtual void onVKShareFailed(string error)
        {
        }
        public virtual void onVKShareSuccess()
        {
        }
        public virtual void onVKShareCancel()
        {
        }
        public virtual void onWebViewCall(string action,string data)
        {
        }

        public void onWebViewCallImpl(string jsonStr)
        {
            Debug.Log("onWebViewCallImpl "+jsonStr);
            if (string.IsNullOrEmpty(jsonStr))
            {
                return;
            }
            var json = JObject.Parse(jsonStr);
            var acion = json["action"]?.Value<string>() ?? "";
            var data = json["data"]?.Value<string>() ?? "";
            onWebViewCall(acion, data);
        }
        public virtual void getBillingConfigAsyncFailure(string error)
        {
        }
        public virtual void getBillingConfigAsyncSuccess(string countryCode)
        {
        }
        //callback end


        public void onVKShareCancelImpl(string msg)
        {
            onVKShareCancel();
        }
        public void onVKShareSuccessImpl(string msg)
        {
            onVKShareSuccess();
        }



        public virtual void onConversionDataSuccess(string jsonString){
            Debug.Log("onConversionDataSuccess " + jsonString);
            Dictionary<string, string> dataMap = JsonConvert.DeserializeObject<Dictionary<string, string>>(jsonString);
            onConversionDataSuccess(dataMap);
        }

        public virtual void onAppOpenAttribution(string jsonString){
            Debug.Log("onAppOpenAttribution " + jsonString);
            Dictionary<string, string> dataMap = JsonConvert.DeserializeObject<Dictionary<string, string>>(jsonString);
            onAppOpenAttribution(dataMap);
        }


		public void CustomerServiceClicked(string msg)
		{
            onCustomerServiceClicked();
        }

		public void onCheckPreRegisterSuccess(string msg)
		{
            onCheckPreRegisterSuccess();
        }

		public void onInitSuccess(string msg)
		{
			onInitSuccess();
		}

		public void onInitFailed(string msg)
		{
			var data = JObject.Parse(msg);
			ErrorMsg errMsg = new ErrorMsg();
			errMsg.errMsg =  data["msg"].Value<string>();
			onInitFailed(errMsg);
		}
		public void onRegisterCallbackImpl(string msg)
        {
            var data = JObject.Parse(msg);
            onRegisterCallback(data["uid"].Value<string>(), data["userName"].Value<string>());
        }

        public void onLoginSuccess(string msg)
        {
            var data = JObject.Parse(msg);
            UserInfo userInfo = new UserInfo();
            userInfo.uid = data["uid"].Value<string>();
            userInfo.token = data["token"].Value<string>();
            userInfo.userName = data["userName"].Value<string>();
            userInfo.openType = data["openType"].Value<string>();
            userInfo.isGuest = data["isGuest"].Value<bool>();
			userInfo.isNewUser = data["isNewUser"].Value<bool>();
			userInfo.isPreReg = data["isPreReg"].Value<bool>();
            userInfo.errMsg = "success";

            onLoginSuccess(userInfo);
        }

        public void onLoginFailed(string msg)
        {
            var data = JObject.Parse(msg);
			ErrorMsg errMsg = new ErrorMsg();
			errMsg.errMsg = (data["msg"] != null) ? data["msg"].Value<string>() : "";
            errMsg.code = data["stateCode"].Value<int>();

			onLoginFailed(errMsg);
        }

        public void onBindFailed(string bindUserInfoStr){
            Debug.Log("onBindFailed "+bindUserInfoStr);
            var bindUserInfo = Newtonsoft.Json.JsonConvert.DeserializeObject<BindUserInfo>(bindUserInfoStr);
            onBindUnbindUserFailed(bindUserInfo);
        }

        public void onBindSuccess(string bindUserInfoStr){
            Debug.Log("onBindSuccess "+bindUserInfoStr);
            var bindUserInfo = Newtonsoft.Json.JsonConvert.DeserializeObject<BindUserInfo>(bindUserInfoStr);
            onBindUnbindUserSuccess(bindUserInfo);
        }

        public void onLogoutSuccess(string msg)
        {
            onLogoutSuccess();
        }



        public void onPaySuccess(string msg)
        {
            var data = JObject.Parse(msg);
            PayResult result = new PayResult();
            result.productId = data["goodsId"].Value<string>();
            result.gameOrderNo = data["orderId"].Value<string>();
            result.orderNo = data["orderNo"].Value<string>();
            result.extraParam = data["extraParam"].Value<string>();

            onPaySuccess(result);
        }

        public void onSubsSkuCallbackImpl(string msg)
        {
            var data = JObject.Parse(msg);
            onSubsSkuCallback(data["productId"].Value<string>(), data["orderId"].Value<string>());
        }

        public void onPayFailed(string msg)
        {
            var data = JObject.Parse(msg);
            PayResult result = new PayResult();

            result.gameOrderNo = data["orderId"].Value<string>();
            result.orderNo = data["orderNo"].Value<string>();
            result.extraParam = data["extraParam"].Value<string>();

			onPayFailed(result);
		}

		public void onPayCancel(string msg)
		{
            var data = JObject.Parse(msg);
			PayResult result = new PayResult();

            result.gameOrderNo = data["orderId"].Value<string>();
            result.orderNo = data["orderNo"].Value<string>();
            result.extraParam = data["extraParam"].Value<string>();

			onPayCancel(result);
		}

		public void onQueryGoogleSkuResultImpl(string json)
		{
            if(string.Equals("",json))
			{
				onQueryGoogleSkuResult(new List<GoogleSku>());
				return;
			}

			List<GoogleSku> list = new List<GoogleSku>();

			try
			{
				JArray array = JArray.Parse(json);
				foreach (JToken item in array)
				{
					GoogleSku sku = new GoogleSku();
					sku.productId = (string)item["productId"];
					sku.type = "inapp";
					sku.title = (string)item["productName"];
					sku.name = (string)item["productName"];
					sku.price = (string)item["price"];

					JToken microsToken = item["microsPrice"];
					if (microsToken != null && microsToken.Type == JTokenType.Integer)
					{
						sku.price_amount_micros = (long)microsToken;
					}
					else
					{
						sku.price_amount_micros = 0;
					}

					sku.price_currency_code = (string)item["currency"];
					sku.description = (string)item["productDesc"];

					list.Add(sku);
				}
			}
			catch (System.Exception e)
			{
				UnityEngine.Debug.LogError("ParseStoreSkuList Error: " + e.Message);
			}

			Debug.Log("onQueryGoogleSkuResult Count " + list.Count);
			onQueryGoogleSkuResult(list);
		}

		public void callLoginTraceEventToGame(string jsonString)
		{
			Debug.Log("callLoginTraceEventToGame " + jsonString);
			JObject jsonObject = JObject.Parse(jsonString);
			onLoginTraceEvent((string)jsonObject["name"], (string)jsonObject["msg"]);
		}

        public void oNOpenReviewFinish(string msg){
			Debug.Log("oNOpenReviewFinish");
			oNOpenReviewFinish();
		}
	}
}

#endif